package jcircus.environment;

import java.util.ArrayList;
import java.util.List;
import jcircus.exceptions.InvalidParameterException;

import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Name;

/**
 * FreeTypeEnv.java
 *
 * @author Angela Freitas
 */
public class FreeTypeEnv {
    
    /**
     * Attribute
     */
    private List<Freetype> freeTypeEnv_;
    
    /**
     * Constructor
     *
     */
    public FreeTypeEnv() {
        this.freeTypeEnv_ = new ArrayList();
    }
    
    /**
     *
     * @param freetype
     */
    public void add(Freetype freetype) {
        this.freeTypeEnv_.add(freetype);
    }
    
    /**
     *
     * @param i
     * @return
     */
    public Freetype get(int i) {
        return (Freetype) this.freeTypeEnv_.get(i);
    }
    
    /**
     *
     * @return
     */
    public int size() {
        return this.freeTypeEnv_.size();
    }
    
    /**
     * 
     * @param name
     * @return
     */
    public boolean isFreeType(String name) {
        
        boolean r = false;
        Freetype freetype;
        
        for (int i=0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            if (name.equals(freetype.getDeclName().toString())) {
                r = true;
            }
        }
        
        return r;
    }
    
    /**
     * 
     * @param name
     * @return
     */
    public boolean isElementFreeType(Name identifier) {
        
        boolean r = false;
        Freetype freetype;
        List branches;
        Branch branch;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            branches = freetype.getBranch();
            
            for (int j=0; j<branches.size(); j++) {
                
                branch = (Branch) branches.get(j);
                if (identifier.toString().equals(branch.getDeclName().toString())) {
                    r = true;
                }
            }
        }
        
        return r;
    }

    /**
     *
     */
    public boolean isElementFreeType(String freeTypeName, String element) {    
        
        boolean r = false;
        Freetype freetype;
        List branches;
        Branch branch;
        
        // Records if freeTypeName has been found in the list of free types
        boolean foundFT = false;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            
            if (freetype.getDeclName().toString().equals(freeTypeName)) {
                foundFT = true;
                branches = freetype.getBranch();

                for (int j=0; j<branches.size(); j++) {

                    branch = (Branch) branches.get(j);
                    if (element.toString().equals(branch.getDeclName().toString())) {
                        r = true;
                    }
                }
            }
        }
        
        if (!foundFT)
            throw new InvalidParameterException("Free type " + freeTypeName + " does not exist.");
        
        return r;
    }
    
    /**
     * Receives an element of a free type, returns the corresponding free type.
     * @param name
     * @return
     */
    public String getNameFreeType(Name identifier) {
        
        String r = null;
        Freetype freetype;
        List branches;
        Branch branch;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            branches = freetype.getBranch();
            
            for (int j = 0; j < branches.size(); j++) {
                
                branch = (Branch) branches.get(j);
                if (identifier.toString().equals(branch.getDeclName().toString())) {
                    r = freetype.getDeclName().toString();
                }
            }
        }
        
        return r;
    }
    
}
